/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cplgtodk;

import com.ibm.hwmca.base.cplgtodk.DiskFile;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CopyLogToDisketteTasklet
extends HwmcaPanelTasklet {
    private static final String TRACE_MASKT = "HCPTTSKT";
    private static final String TRACE_MASKF = "HCPTTSKF";
    private static final String TRACE_MASKD = "HCPTTSKD";
    private static final int ZIP_BLOCK_SIZE = 2048;
    private static final int MAX_BYTES_ON_FLOPPY = 1422998;
    private static final int EXTRA_BYTES_ON_FLOPPY = 2;
    private static final String LOG_FILE_NAME = "iqyylog.log";

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> service: ");
        if (request.isInitialRequest()) {
            try {
                String filePath = BaseFileControl.getFilePath(LOG_FILE_NAME);
                Trace.trace(TRACE_MASKT, "filePath " + filePath);
                File inputFile = new File(filePath + LOG_FILE_NAME);
                File zippedFile = this.compressFile(inputFile);
                if (zippedFile != null) {
                    Vector diskFiles = this.splitFile(zippedFile, inputFile);
                    boolean ret = this.copyFilesToFloppy(zippedFile, diskFiles);
                    zippedFile.delete();
                    if (ret) {
                        BaseMessageText msgText = new BaseMessageText("HCPF0001");
                        BaseMessageTitle msgTitle = new BaseMessageTitle("HCPFTITL");
                        this.showMessageBox(true, msgTitle, msgText, MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    }
                }
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "compressFile exception: " + e);
            }
            response.terminate();
        } else if (request.isDisposed()) {
            response.terminate();
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("event");
            if (event == null) {
                String eventname = (String)request.getData("menuevent");
            } else {
                String eventname = event.getElementName();
            }
            Trace.trace(TRACE_MASKT, "<< service: ");
            response.noAction();
        }
    }

    /*
     * WARNING - void declaration
     */
    public File compressFile(File inputFile) {
        try {
            int count;
            Trace.trace(TRACE_MASKT, ">> compressFile: ");
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "cplgtodk.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "cplgcomp.busy.text"));
            File tempZipFile = File.createTempFile(inputFile.getName(), "zip");
            tempZipFile.deleteOnExit();
            Trace.trace(TRACE_MASKT, "tempZipFile name " + tempZipFile.getName());
            Trace.trace(TRACE_MASKT, "tempZipFile path " + tempZipFile.getPath());
            FileOutputStream outputStream = new FileOutputStream(tempZipFile);
            ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
            zipStream.putNextEntry(new ZipEntry(inputFile.getName()));
            FileInputStream inputStream = new FileInputStream(inputFile);
            BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, 2048);
            byte[] data = new byte[2048];
            while ((count = bufInputStream.read(data, 0, 2048)) != -1) {
                void var8_9;
                zipStream.write(data, 0, (int)var8_9);
            }
            zipStream.close();
            outputStream.close();
            bufInputStream.close();
            Trace.trace(TRACE_MASKT, "After compress " + tempZipFile.length());
            this.destroyBusyDialog();
            Trace.trace(TRACE_MASKT, "<< compressFile: ");
            return tempZipFile;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "compressFile exception: " + e);
            Trace.trace(TRACE_MASKT, "<< compressFile: ");
            return null;
        }
    }

    public Vector splitFile(File inputFile, File originalFile) {
        long fileSize = 0L;
        int sizeOfNewFile = 0;
        long offSet = 0L;
        boolean isDone = false;
        int diskNumber = 0;
        Vector<DiskFile> result = new Vector<DiskFile>();
        boolean isMultiDisk = false;
        Object localFile = null;
        Trace.trace(TRACE_MASKT, ">> splitFile: ");
        long bytesLeft = fileSize = inputFile.length();
        while (!isDone) {
            sizeOfNewFile = (int)Math.min(1422998L, bytesLeft);
            offSet = diskNumber * sizeOfNewFile;
            ++diskNumber;
            if ((bytesLeft -= (long)sizeOfNewFile) == 0L) {
                offSet = fileSize - (long)sizeOfNewFile;
                isDone = true;
            }
            DiskFile newDiskFile = new DiskFile(originalFile.getName(), originalFile.getPath(), offSet, sizeOfNewFile, diskNumber);
            result.addElement(newDiskFile);
        }
        Trace.trace(TRACE_MASKT, "<< splitFile: ");
        return result;
    }

    public boolean copyFilesToFloppy(File inputFile, Vector diskFiles) {
        Trace.trace(TRACE_MASKT, ">> copyFilesToFloppy: ");
        boolean linuxcopyret = false;
        boolean retvalue = false;
        MediaServices mediaServices = null;
        MediaDeviceIdentifier mediaIdentifier = null;
        MediaDevice mediaDevice = null;
        try {
            Object outStream = null;
            boolean retry = false;
            boolean userCanceled = false;
            boolean formatDisk = false;
            boolean alwaysFormat = false;
            int bytesRead = 0;
            int totalRead = 0;
            byte[] buffer = null;
            LocalizableText name = new LocalizableText("CPY");
            mediaServices = MediaServices.getMediaServices();
            mediaIdentifier = mediaServices.getPreferredDevice(1);
            mediaDevice = mediaServices.requestLock(name, mediaIdentifier);
            int i = 0;
            while (i < diskFiles.size()) {
                File outFile;
                RandomAccessFile masterFile;
                BaseMessageText msgText = new BaseMessageText("HCPF0005", new String[]{new Integer(i + 1).toString(), new Integer(diskFiles.size()).toString()});
                BaseMessageTitle msgTitle = new BaseMessageTitle("HCPFTITL");
                retry = true;
                while (retry) {
                    mediaDevice.unmount();
                    LocalizableText ans = this.showMessageBox(true, msgTitle, msgText, MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                    if (ans.equals(CommonMsgInterface.CANCEL_BUTTON)) {
                        mediaDevice.unlock();
                        retry = false;
                        userCanceled = true;
                    }
                    if (userCanceled) continue;
                    try {
                        mediaDevice.mountReadWrite();
                        retry = false;
                        if (!mediaDevice.isReadOnly()) continue;
                        Trace.trace(TRACE_MASKT, "copyFilesToFloppy: isReadOnly");
                        msgText = new BaseMessageText("HCPF0006");
                        retry = true;
                    }
                    catch (NoMediaPresentException ex) {
                        Trace.trace(TRACE_MASKT, "copyFilesToFloppy: No disk in drive");
                        msgText = new BaseMessageText("HCPF0004", new String[]{new Integer(i + 1).toString()});
                        retry = true;
                    }
                    catch (MediaWriteProtectedException ex) {
                        Trace.trace(TRACE_MASKT, "copyFilesToFloppy: isReadOnly");
                        msgText = new BaseMessageText("HCPF0006");
                        retry = true;
                    }
                    catch (MediaDeviceException ex) {
                        Trace.trace(TRACE_MASKT, "copyFilesToFloppy: bad disk");
                        msgText = new BaseMessageText("HCPF0008");
                        retry = true;
                    }
                }
                if (!userCanceled) {
                    masterFile = new RandomAccessFile(inputFile, "r");
                    formatDisk = false;
                    if (!alwaysFormat && mediaDevice.getTotalSpace() != mediaDevice.getAvailableSpace()) {
                        LocalizableText ans = this.showMessageBox(true, msgTitle, new BaseMessageText("HCPF0009"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, new LocalizableText(BaseTextBundle.getBundleName(), "cplgtodk.always.text"), CommonMsgInterface.CANCEL_BUTTON});
                        if (ans.equals(CommonMsgInterface.OK_BUTTON)) {
                            formatDisk = true;
                        } else if (ans.equals(new LocalizableText(BaseTextBundle.getBundleName(), "cplgtodk.always.text"))) {
                            alwaysFormat = true;
                        } else if (ans.equals(CommonMsgInterface.CANCEL_BUTTON)) {
                            retvalue = false;
                            userCanceled = true;
                            break;
                        }
                    }
                    this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "cplgtodk.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "cplgform.busy.text"));
                    mediaDevice.unmount();
                    if (formatDisk || alwaysFormat) {
                        mediaDevice.format("COPYLOG", 1);
                    }
                    mediaDevice.mountReadWrite();
                    this.destroyBusyDialog();
                    Trace.trace(TRACE_MASKT, "compressFile: After format - size = " + mediaDevice.getAvailableSpace());
                    DiskFile diskFile = (DiskFile)diskFiles.elementAt(i);
                    Trace.trace(TRACE_MASKT, "diskFile name " + diskFile.getFileName());
                    outFile = null;
                    outFile = new File(diskFile.getFileName());
                    buffer = new byte[diskFile.getFileSize() + 2];
                    masterFile.seek(diskFile.getOffSet());
                    bytesRead = masterFile.read(buffer, 0, diskFile.getFileSize()) + 2;
                    buffer[diskFile.getFileSize()] = new Integer(i + 1).byteValue();
                    buffer[diskFile.getFileSize() + 1] = new Integer(diskFiles.size()).byteValue();
                    totalRead += bytesRead;
                } else {
                    retvalue = false;
                    break;
                }
                Trace.trace(TRACE_MASKT, "outFile.getName() " + outFile.getName());
                FileOutputStream outstream = new FileOutputStream(outFile);
                Trace.trace(TRACE_MASKT, "compressFile: before writing stream to buffer - bytesread = " + bytesRead);
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "cplgtodk.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "cplgcrea.busy.text", new String[]{new Integer(i + 1).toString(), new Integer(diskFiles.size()).toString()}));
                outstream.write(buffer, 0, bytesRead);
                outstream.flush();
                outstream.close();
                mediaDevice.unmount();
                mediaDevice.mountReadWrite();
                FileUtilities.copy(outFile, new File("/mnt/floppy"));
                mediaDevice.unmount();
                this.destroyBusyDialog();
                Trace.trace(TRACE_MASKT, "Before delete");
                outFile.delete();
                masterFile.close();
                retvalue = true;
                ++i;
            }
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "copyFilesToFloppy exception: " + e);
            try {
                LocalizableText ans = this.showMessageBox(true, new BaseMessageTitle("HCPFTITL"), new BaseMessageText("HCPF0008"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
            }
            catch (Exception ex) {
                // empty catch block
            }
            retvalue = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "copyFilesToFloppy exception: " + e);
            retvalue = false;
        }
        Trace.trace(TRACE_MASKT, "<< copyFilesToFloppy: ");
        try {
            mediaDevice.unlock();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "copyFilesToFloppy unlock exception: " + e);
        }
        return retvalue;
    }
}

